<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:wwsplits="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:wwtoc="urn:WebWorks-Engine-TOC-Schema"
                              xmlns:wwlinks="urn:WebWorks-Engine-Links-Schema"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwfiles="urn:WebWorks-Engine-Files-Schema"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwproject="urn:WebWorks-Publish-Project"
                              xmlns:wwbaggage="urn:WebWorks-Baggage-Schema"
                              xmlns:wwpage="urn:WebWorks-Page-Template-Schema"
                              xmlns:wwlocale="urn:WebWorks-Locale-Schema"
                              xmlns:wwprogress="urn:WebWorks-XSLT-Extension-Progress"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwstring="urn:WebWorks-XSLT-Extension-StringUtilities"
                              xmlns:wwfilesext="urn:WebWorks-XSLT-Extension-Files"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              xmlns:wwexsldoc="urn:WebWorks-XSLT-Extension-Document"
                              exclude-result-prefixes="xsl msxsl wwtoc wwlinks wwmode wwfiles wwdoc wwsplits wwproject wwbaggage wwpage wwlocale wwprogress wwlog wwfilesystem wwuri wwstring wwfilesext wwprojext wwexsldoc"
>
 <xsl:param name="GlobalInput" />
 <xsl:param name="GlobalPipelineName" />
 <xsl:param name="GlobalProject" />
 <xsl:param name="GlobalFiles" />
 <xsl:param name="ParameterDependsType" />
 <xsl:param name="ParameterType" />
 <xsl:param name="ParameterDocumentType" />
 <xsl:param name="ParameterBaggageType" />
 <xsl:param name="ParameterLocaleType" />
 <xsl:param name="ParameterSplashPageTemplateURI" />
 <xsl:param name="ParameterPageTemplateURI" />
 <xsl:param name="ParameterParcelPageTemplateURI" />
 <xsl:param name="ParameterConnectPageTemplateURI" />
 <xsl:param name="ParameterCopySplitFileType" />
 <xsl:param name="ParameterBaggageSplitFileType" />
 <xsl:param name="ParameterSplashSplitFileType" />
 <xsl:param name="ParameterParcelInfoSplitFileType" />
 <xsl:param name="ParameterIndexSplitFileType" />
 <xsl:param name="ParameterCSSSplitFileType" />


 <xsl:output encoding="UTF-8" indent="yes" />
 <xsl:namespace-alias stylesheet-prefix="wwsplits" result-prefix="#default" />
 <xsl:strip-space elements="*" />


 <xsl:include href="wwtransform:common/files/filter.xsl" />
 <xsl:include href="wwtransform:common/files/format.xsl" />
 <xsl:include href="wwtransform:common/pages/pagetemplate.xsl" />
 <xsl:include href="wwformat:Transforms/connect_utilities.xsl" />


 <xsl:key name="wwfiles-files-by-type" match="wwfiles:File" use="@type" />
 <xsl:key name="wwfiles-files-by-groupid-type" match="wwfiles:File" use="concat(@groupID, ':', @type)" />


 <xsl:variable name="GlobalActionChecksum">
  <xsl:variable name="VarTransformChecksums">
   <xsl:value-of select="concat(wwuri:AsFilePath('wwtransform:self'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:self')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath($ParameterSplashPageTemplateURI), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath($ParameterSplashPageTemplateURI)))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath($ParameterPageTemplateURI), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath($ParameterPageTemplateURI)))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath($ParameterParcelPageTemplateURI), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath($ParameterParcelPageTemplateURI)))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath($ParameterConnectPageTemplateURI), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath($ParameterConnectPageTemplateURI)))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/files/filter.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/files/filter.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/files/format.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/files/format.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/pages/pagetemplate.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/pages/pagetemplate.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwformat:Transforms/connect_utilities.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwformat:Transforms/connect_utilities.xsl')))" />
  </xsl:variable>
  <xsl:value-of select="wwstring:MD5Checksum($VarTransformChecksums)" />
 </xsl:variable>


 <!-- Splash Page Template -->
 <!--                      -->
 <xsl:variable name="GlobalSplashPageTemplatePath" select="wwuri:AsFilePath($ParameterSplashPageTemplateURI)" />
 <xsl:variable name="GlobalSplashPageTemplate" select="wwexsldoc:LoadXMLWithoutResolver($GlobalSplashPageTemplatePath)" />


 <!-- Page Template -->
 <!--               -->
 <xsl:variable name="GlobalPageTemplatePath" select="wwuri:AsFilePath($ParameterPageTemplateURI)" />
 <xsl:variable name="GlobalPageTemplate" select="wwexsldoc:LoadXMLWithoutResolver($GlobalPageTemplatePath)" />


 <!-- Parcel Page Template -->
 <!--                      -->
 <xsl:variable name="GlobalParcelPageTemplatePath" select="wwuri:AsFilePath($ParameterParcelPageTemplateURI)" />
 <xsl:variable name="GlobalParcelPageTemplate" select="wwexsldoc:LoadXMLWithoutResolver($GlobalParcelPageTemplatePath)" />


 <!-- Connect Page Template -->
 <!--                       -->
 <xsl:variable name="GlobalConnectPageTemplatePath" select="wwuri:AsFilePath($ParameterConnectPageTemplateURI)" />
 <xsl:variable name="GlobalConnectPageTemplate" select="wwexsldoc:LoadXMLWithoutResolver($GlobalConnectPageTemplatePath)" />


 <xsl:variable name="GlobalFilenameSpacesToUnderscores" select="wwprojext:GetFormatSetting('filename-spaces-to-underscores') = 'true'" />
 <xsl:variable name="GlobalFilenameSpacesToUnderscoresSearchString">
  <xsl:if test="$GlobalFilenameSpacesToUnderscores">
   <xsl:text> </xsl:text>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="GlobalFilenameSpacesToUnderscoresReplaceString">
  <xsl:if test="$GlobalFilenameSpacesToUnderscores">
   <xsl:text>_</xsl:text>
  </xsl:if>
 </xsl:variable>

 <xsl:variable name="GlobalInvalidPathCharactersExpression" select="'[#&amp;?]'" />

 <xsl:template match="/">
  <wwfiles:Files version="1.0">

   <!-- Iterate input documents -->
   <!--                         -->
   <xsl:for-each select="$GlobalFiles[1]">
    <xsl:variable name="VarFilesByType" select="key('wwfiles-files-by-type', $ParameterDependsType)" />

    <xsl:value-of select="wwprogress:Start(count($VarFilesByType))" />

    <!-- Load locale -->
    <!--             -->
    <xsl:variable name="VarFilesLocale" select="key('wwfiles-files-by-type', $ParameterLocaleType)" />
    <xsl:variable name="VarLocale" select="wwexsldoc:LoadXMLWithoutResolver($VarFilesLocale/@path)" />

    <xsl:for-each select="$VarFilesByType">
     <xsl:value-of select="wwprogress:Start(1)" />

     <xsl:variable name="VarFilesDocument" select="." />

     <xsl:variable name="VarPath" select="wwfilesystem:Combine(wwfilesystem:GetDirectoryName($VarFilesDocument/@path), concat(translate($ParameterType, ':', '_'),'.xml'))" />

     <!-- Get format files -->
     <!--                  -->
     <xsl:variable name="VarFormatFilesAsXML">
      <xsl:call-template name="Files-Format-GetRelativeFiles">
       <xsl:with-param name="ParamRelativeURIPath" select="'Files'" />
      </xsl:call-template>
     </xsl:variable>
     <xsl:variable name="VarFormatFiles" select="msxsl:node-set($VarFormatFilesAsXML)" />
     <xsl:variable name="VarFormatFilesPaths">
      <xsl:for-each select="$VarFormatFiles/wwfiles:Files/wwfiles:File">
       <xsl:value-of select="@path" />
       <xsl:value-of select="':'" />
      </xsl:for-each>
     </xsl:variable>
     <xsl:variable name="VarFormatFilesChecksum" select="wwstring:MD5Checksum($VarFormatFilesPaths)" />

     <!-- Get page template files -->
     <!--                         -->
     <xsl:variable name="VarPageTemplateFilesAsXML">
      <!-- Combine all page template files -->
      <!--                                 -->
      <xsl:variable name="VarPageTemplateFilesWithDuplicatesAsXML">
       <xsl:apply-templates select="$GlobalSplashPageTemplate" mode="wwmode:pagetemplate-files" />
       <xsl:apply-templates select="$GlobalPageTemplate" mode="wwmode:pagetemplate-files" />
       <xsl:apply-templates select="$GlobalParcelPageTemplate" mode="wwmode:pagetemplate-files" />
       <xsl:apply-templates select="$GlobalConnectPageTemplate" mode="wwmode:pagetemplate-files" />
      </xsl:variable>
      <xsl:variable name="VarPageTemplateFilesWithDuplicates" select="msxsl:node-set($VarPageTemplateFilesWithDuplicatesAsXML)" />

      <!-- Eliminate duplicates -->
      <!--                      -->
      <xsl:for-each select="$VarPageTemplateFilesWithDuplicates/wwpage:File">
       <xsl:variable name="VarPageTemplateFile" select="." />

       <xsl:variable name="VarPageTemplateFilesWithPath" select="key('wwpage-files-by-path', $VarPageTemplateFile/@path)" />
       <xsl:if test="count($VarPageTemplateFilesWithPath[1] | $VarPageTemplateFile) = 1">
        <xsl:copy-of select="$VarPageTemplateFile" />
       </xsl:if>
      </xsl:for-each>
     </xsl:variable>
     <xsl:variable name="VarPageTemplateFiles" select="msxsl:node-set($VarPageTemplateFilesAsXML)" />
     <xsl:variable name="VarPageTemplateFilesPaths">
      <xsl:for-each select="$VarPageTemplateFiles/wwpage:File">
       <xsl:value-of select="@path" />
       <xsl:value-of select="':'" />
      </xsl:for-each>
     </xsl:variable>
     <xsl:variable name="VarPageTemplateFilesChecksum" select="wwstring:MD5Checksum($VarPageTemplateFilesPaths)" />

     <!-- Get project files -->
     <!--                   -->
     <xsl:variable name="VarProjectFiles" select="wwfilesystem:GetFiles(wwprojext:GetProjectFilesDirectoryPath())" />
     <xsl:variable name="VarProjectFilesPaths">
      <xsl:for-each select="$VarProjectFiles/wwfiles:Files/wwfiles:File">
       <xsl:value-of select="@path" />
       <xsl:value-of select="':'" />
      </xsl:for-each>
     </xsl:variable>
     <xsl:variable name="VarProjectFilesChecksum" select="wwstring:MD5Checksum($VarProjectFilesPaths)" />

     <!-- Get baggage files -->
     <!--                   -->
     <xsl:variable name="VarBaggageFilesFile" select="key('wwfiles-files-by-groupid-type', concat($VarFilesDocument/@groupID, ':', $ParameterBaggageType))[1]" />

     <!-- Determine group name -->
     <!--                      -->
     <xsl:variable name="VarGroupName" select="wwprojext:GetGroupName($VarFilesDocument/@groupID)" />

     <!-- Determine group output directory path -->
     <!--                                       -->
     <xsl:variable name="VarGroupOutputDirectoryPath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), wwstring:ReplaceWithExpression(wwstring:Replace($VarGroupName, $GlobalFilenameSpacesToUnderscoresSearchString, $GlobalFilenameSpacesToUnderscoresReplaceString), $GlobalInvalidPathCharactersExpression, '_'))" />

     <!-- Transform -->
     <!--           -->
     <xsl:variable name="VarProjectChecksum" select="concat($GlobalProject/wwproject:Project/@ChangeID, ':', $VarFormatFilesChecksum, ':', $VarPageTemplateFilesChecksum, ':', $VarProjectFilesChecksum)" />
     <xsl:variable name="VarUpToDate" select="wwfilesext:UpToDate($VarPath, $VarProjectChecksum, $VarFilesDocument/@groupID, '', $GlobalActionChecksum)" />
     <xsl:if test="not($VarUpToDate)">
      <xsl:variable name="VarResultAsXML">
       <!-- Load document -->
       <!--               -->
       <xsl:variable name="VarSplits" select="wwexsldoc:LoadXMLWithoutResolver($VarFilesDocument/@path)" />

       <!-- Add files -->
       <!--           -->
       <xsl:call-template name="Files">
        <xsl:with-param name="ParamLocale" select="$VarLocale" />
        <xsl:with-param name="ParamGroupID" select="$VarFilesDocument/@groupID" />
        <xsl:with-param name="ParamGroupOutputDirectoryPath" select="$VarGroupOutputDirectoryPath" />
        <xsl:with-param name="ParamGroupName" select="$VarGroupName" />
        <xsl:with-param name="ParamFormatFiles" select="$VarFormatFiles" />
        <xsl:with-param name="ParamProjectFiles" select="$VarProjectFiles" />
        <xsl:with-param name="ParamPageTemplateFiles" select="$VarPageTemplateFiles" />
        <xsl:with-param name="ParamSplits" select="$VarSplits" />
        <xsl:with-param name="ParamBaggageFiles" select="wwexsldoc:LoadXMLWithoutResolver($VarBaggageFilesFile/@path)/wwbaggage:Baggage/wwbaggage:File" />
       </xsl:call-template>
      </xsl:variable>
      <xsl:variable name="VarResult" select="msxsl:node-set($VarResultAsXML)" />
      <xsl:variable name="VarWriteResult" select="wwexsldoc:Document($VarResult, $VarPath, 'utf-8', 'xml', '1.0', 'yes')" />
     </xsl:if>

     <!-- Report Files -->
     <!--              -->
     <wwfiles:File path="{$VarPath}" type="{$ParameterType}" checksum="{wwfilesystem:GetChecksum($VarPath)}" projectchecksum="{$VarProjectChecksum}" groupID="{$VarFilesDocument/@groupID}" documentID="" actionchecksum="{$GlobalActionChecksum}" category="" use="">
      <wwfiles:Depends path="{$VarFilesLocale/@path}" checksum="{$VarFilesLocale/@checksum}" groupID="{$VarFilesLocale/@groupID}" documentID="{$VarFilesLocale/@documentID}" />
      <wwfiles:Depends path="{$VarFilesDocument/@path}" checksum="{$VarFilesDocument/@checksum}" groupID="{$VarFilesDocument/@groupID}" documentID="{$VarFilesDocument/@documentID}" />
      <wwfiles:Depends path="{$VarBaggageFilesFile/@path}" checksum="{$VarBaggageFilesFile/@checksum}" groupID="{$VarBaggageFilesFile/@groupID}" documentID="{$VarBaggageFilesFile/@documentID}" />
      <wwfiles:Depends path="{$GlobalSplashPageTemplatePath}" checksum="{wwfilesystem:GetChecksum($GlobalSplashPageTemplatePath)}" groupID="" documentID="" />
      <wwfiles:Depends path="{$GlobalPageTemplatePath}" checksum="{wwfilesystem:GetChecksum($GlobalPageTemplatePath)}" groupID="" documentID="" />
      <wwfiles:Depends path="{$GlobalParcelPageTemplatePath}" checksum="{wwfilesystem:GetChecksum($GlobalParcelPageTemplatePath)}" groupID="" documentID="" />
      <wwfiles:Depends path="{$GlobalConnectPageTemplatePath}" checksum="{wwfilesystem:GetChecksum($GlobalConnectPageTemplatePath)}" groupID="" documentID="" />
     </wwfiles:File>

     <xsl:value-of select="wwprogress:End()" />
    </xsl:for-each>

    <xsl:value-of select="wwprogress:End()" />
   </xsl:for-each>

  </wwfiles:Files>
 </xsl:template>

 <xsl:template name="Files">
  <xsl:param name="ParamLocale" />
  <xsl:param name="ParamGroupID" />
  <xsl:param name="ParamGroupOutputDirectoryPath" />
  <xsl:param name="ParamGroupName" />
  <xsl:param name="ParamFormatFiles" />
  <xsl:param name="ParamProjectFiles" />
  <xsl:param name="ParamPageTemplateFiles" />
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamBaggageFiles" />

  <!-- Book title -->
  <!--            -->
  <xsl:variable name="VarBookTitle">
   <xsl:call-template name="Connect-BookTitle">
    <xsl:with-param name="ParamProject" select="$GlobalProject" />
    <xsl:with-param name="ParamGroupID" select="$ParamGroupID" />
   </xsl:call-template>
  </xsl:variable>

  <!-- Copy splits with new file entries added -->
  <!--                                         -->
  <wwsplits:Splits>
   <xsl:copy-of select="$ParamSplits/wwsplits:Splits/@*" />

   <!-- Format Files -->
   <!--              -->
   <xsl:for-each select="$ParamFormatFiles/wwfiles:Files/wwfiles:File">
    <xsl:variable name="VarFormatFile" select="." />

    <xsl:variable name="VarConnectRelativeFormatFilePath">
     <xsl:call-template name="Connect-File-Path">
      <xsl:with-param name="ParamPath" select="$VarFormatFile/@path" />
     </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="VarFormatFilePath" select="wwfilesystem:Combine($ParamGroupOutputDirectoryPath, $VarConnectRelativeFormatFilePath)" />

    <!-- Allow? -->
    <!--        -->
    <xsl:variable name="VarAllow">
     <xsl:call-template name="Files-Filter-Allow">
      <xsl:with-param name="ParamPath" select="$VarFormatFilePath" />
     </xsl:call-template>
    </xsl:variable>
    <xsl:if test="$VarAllow = 'true'">
     <!-- Emit -->
     <!--      -->
     <wwsplits:File groupID="{$ParamGroupID}" documentID="" id="" type="{$ParameterCopySplitFileType}" source="{wwuri:MakeAbsolute('wwformat:Files/', $VarFormatFile/@path)}" path="{$VarFormatFilePath}" title="" />
    </xsl:if>
   </xsl:for-each>

   <!-- Page Template Files -->
   <!--                     -->
   <xsl:for-each select="$ParamPageTemplateFiles/wwpage:File">
    <xsl:variable name="VarPageTemplateFile" select="." />

    <xsl:variable name="VarConnectRelativePageTemplateFilePath">
     <xsl:call-template name="Connect-File-Path">
      <xsl:with-param name="ParamPath" select="$VarPageTemplateFile/@path" />
     </xsl:call-template>
    </xsl:variable>

    <wwsplits:File groupID="{$ParamGroupID}" documentID="" id="" type="{$ParameterCopySplitFileType}" source="{concat('wwformat:Pages/', $VarPageTemplateFile/@path)}" path="{wwfilesystem:Combine($ParamGroupOutputDirectoryPath, $VarConnectRelativePageTemplateFilePath)}" title="" />
   </xsl:for-each>

   <!-- Parcel Info -->
   <!--             -->
   <wwsplits:File groupID="{$ParamGroupID}" documentID="" id="" type="{$ParameterParcelInfoSplitFileType}" source="" path="{$ParamGroupOutputDirectoryPath}.html" title="{$VarBookTitle}" />

   <!-- Reprocess existing split entries -->
   <!--                                  -->
   <xsl:apply-templates select="$ParamSplits/wwsplits:Splits/wwsplits:*" mode="wwmode:reprocess-splits">
    <xsl:with-param name="ParamGroupOutputDirectoryPath" select="$ParamGroupOutputDirectoryPath" />
   </xsl:apply-templates>

   <!-- Index -->
   <!--       -->
   <xsl:if test="wwprojext:GetFormatSetting('index-generate', 'true') = 'true'">
    <wwsplits:File groupID="{$ParamGroupID}" documentID="" id="" type="{$ParameterIndexSplitFileType}" source="" path="{$ParamGroupOutputDirectoryPath}_ix.html" title="{$ParamLocale/wwlocale:Locale/wwlocale:Strings/wwlocale:String[@name = 'IXTitle']/@value}" />
   </xsl:if>

   <!-- Project Files -->
   <!--               -->
   <xsl:variable name="VarProjectFilesDirectoryPath" select="wwfilesystem:Combine(wwprojext:GetProjectFilesDirectoryPath(), 'dummy.component')" />
   <xsl:for-each select="$ParamProjectFiles/wwfiles:Files/wwfiles:File">
    <xsl:variable name="VarProjectFile" select="." />

    <xsl:variable name="VarRelativePath" select="wwfilesystem:GetRelativeTo($VarProjectFile/@path, $VarProjectFilesDirectoryPath)" />
    <xsl:variable name="VarRelativeURI" select="wwuri:GetRelativeTo($VarProjectFile/@path, 'wwprojfile:dummy.component')" />
    <xsl:variable name="VarConnectRelativePath">
     <xsl:call-template name="Connect-File-Path">
      <xsl:with-param name="ParamPath" select="$VarRelativePath" />
     </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="VarProjectFilePath" select="wwfilesystem:Combine($ParamGroupOutputDirectoryPath, $VarConnectRelativePath)" />

    <!-- Allow? -->
    <!--        -->
    <xsl:variable name="VarAllow">
     <xsl:call-template name="Files-Filter-Allow">
      <xsl:with-param name="ParamPath" select="$VarProjectFilePath" />
     </xsl:call-template>
    </xsl:variable>
    <xsl:if test="$VarAllow = 'true'">
     <!-- Emit -->
     <!--      -->
     <wwsplits:File groupID="{$ParamGroupID}" documentID="" id="" type="{$ParameterCopySplitFileType}" source="{concat('wwprojfile:', $VarRelativeURI)}" path="{$VarProjectFilePath}" title="" />
    </xsl:if>
   </xsl:for-each>

   <!-- CSS Stylesheets -->
   <!--                 -->
   <xsl:for-each select="$GlobalFiles[1]">
    <xsl:variable name="VarFilesByType" select="key('wwfiles-files-by-groupid-type', concat($ParamGroupID, ':', $ParameterDocumentType))" />

    <xsl:for-each select="$VarFilesByType">
     <xsl:variable name="VarFilesDocumentNode" select="." />

     <!-- CSS Path -->
     <!--          -->
     <xsl:variable name="VarOutputDocumentDirectoryPath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), wwstring:ReplaceWithExpression(wwstring:Replace(wwprojext:GetDocumentGroupPath($VarFilesDocumentNode/@documentID), $GlobalFilenameSpacesToUnderscoresSearchString, $GlobalFilenameSpacesToUnderscoresReplaceString), $GlobalInvalidPathCharactersExpression, '_'))" />

     <xsl:variable name="VarRelativePath" select="wwfilesystem:GetRelativeTo($VarOutputDocumentDirectoryPath, wwfilesystem:Combine($ParamGroupOutputDirectoryPath, 'dummy.file'))" /> 	 	 
     <xsl:variable name="VarConnectRelativePath"> 	 	 
      <xsl:call-template name="Connect-File-Path"> 	 	 
       <xsl:with-param name="ParamPath" select="$VarRelativePath" /> 	 	 
      </xsl:call-template> 	 	 
     </xsl:variable> 	 	 
     <xsl:variable name="VarOutputDirectoryPath" select="wwfilesystem:Combine($ParamGroupOutputDirectoryPath, $VarConnectRelativePath)" />

     <xsl:variable name="VarBaseFileName" select="wwfilesystem:GetFileNameWithoutExtension(wwprojext:GetDocumentPath($VarFilesDocumentNode/@documentID))" />
     <xsl:variable name="VarConnectBaseFileName">
      <xsl:call-template name="Connect-File-Path">
       <xsl:with-param name="ParamPath" select="$VarBaseFileName" />
      </xsl:call-template>
     </xsl:variable>
     <xsl:variable name="VarPath" select="wwfilesystem:Combine($VarOutputDirectoryPath, 'css', concat(wwstring:ReplaceWithExpression(wwstring:Replace($VarConnectBaseFileName, $GlobalFilenameSpacesToUnderscoresSearchString, $GlobalFilenameSpacesToUnderscoresReplaceString), $GlobalInvalidPathCharactersExpression, '_'), '.css'))" />

     <wwsplits:File groupID="{$ParamGroupID}" documentID="{$VarFilesDocumentNode/@documentID}" id="" type="{$ParameterCSSSplitFileType}" source="" path="{$VarPath}" title="" />
    </xsl:for-each>
   </xsl:for-each>

   <!-- Baggage -->
   <!--         -->
   <xsl:for-each select="$ParamBaggageFiles">
    <xsl:variable name="VarBaggageFile" select="." />

    <xsl:variable name="VarConnectFileName">
     <xsl:call-template name="Connect-File-Path">
      <xsl:with-param name="ParamPath" select="wwfilesystem:GetFileName($VarBaggageFile/@path)" />
     </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="VarPath" select="wwfilesystem:Combine($ParamGroupOutputDirectoryPath, 'baggage', wwstring:ReplaceWithExpression(wwstring:Replace($VarConnectFileName, $GlobalFilenameSpacesToUnderscoresSearchString, $GlobalFilenameSpacesToUnderscoresReplaceString), $GlobalInvalidPathCharactersExpression, '_'))" />

    <wwsplits:File groupID="{$ParamGroupID}" documentID="" id="" type="{$ParameterBaggageSplitFileType}" source="{$VarBaggageFile/@path}" path="{$VarPath}" title="" />
   </xsl:for-each>
  </wwsplits:Splits>
 </xsl:template>


 <!-- wwmode:reprocess-splits -->
 <!--                         -->

 <xsl:template match="wwsplits:*" mode="wwmode:reprocess-splits">
  <xsl:param name="ParamSplitsEntry" select="." />
  <xsl:param name="ParamGroupOutputDirectoryPath" />

  <!-- Reset output path -->
  <!--                   -->
  <xsl:variable name="VarOutputPath">
   <xsl:variable name="VarRelativePath" select="wwfilesystem:GetRelativeTo($ParamSplitsEntry/@path, wwfilesystem:Combine($ParamGroupOutputDirectoryPath, 'dummy.file'))" />
   <xsl:variable name="VarConnectRelativePath">
    <xsl:call-template name="Connect-File-Path">
     <xsl:with-param name="ParamPath" select="$VarRelativePath" />
    </xsl:call-template>
   </xsl:variable>
   <xsl:value-of select="wwfilesystem:Combine($ParamGroupOutputDirectoryPath, $VarConnectRelativePath)" />
  </xsl:variable>

  <!-- Emit element with updated path -->
  <!--                                -->
  <xsl:copy>
   <xsl:copy-of select="$ParamSplitsEntry/@*[local-name() != 'path']" />
   <xsl:attribute name="path">
    <xsl:value-of select="$VarOutputPath" />
   </xsl:attribute>

   <!-- Process children -->
   <!--                  -->
   <xsl:apply-templates mode="wwmode:reprocess-splits">
    <xsl:with-param name="ParamGroupOutputDirectoryPath" select="$ParamGroupOutputDirectoryPath" />
   </xsl:apply-templates>
  </xsl:copy>
 </xsl:template>


 <xsl:template match="*" mode="wwmode:reprocess-splits">
  <xsl:param name="ParamGroupOutputDirectoryPath" />

  <!-- Preserve as is -->
  <!--                -->
  <xsl:copy>
   <xsl:copy-of select="@*" />

   <!-- Process children -->
   <!--                  -->
   <xsl:apply-templates mode="wwmode:reprocess-splits">
    <xsl:with-param name="ParamGroupOutputDirectoryPath" select="$ParamGroupOutputDirectoryPath" />
   </xsl:apply-templates>
  </xsl:copy>
 </xsl:template>


 <xsl:template match="text() | comment() | processing-instruction()" mode="wwmode:reprocess-splits">
  <xsl:param name="ParamGroupOutputDirectoryPath" />

  <!-- Ignore -->
  <!--        -->
 </xsl:template>
</xsl:stylesheet>
